c     ---------------------------------------------------------------------INPU
      subroutine inpu (iflag,ndatam,propma,ndof,coord,iele,iface,icode,
     +fact)
      implicit double precision (a-h, o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      dimension propma(ndatam,1),ndof(3,1),coord(2,1),iele(5,1),
     +iface(2,1),icode(1)
c
c     This routine reads the geometry, material, and other input data
c      from the specified input file and stores them either in the main 
c      array Ia or in the scratch files.
c
c                              Sudip S. Bhattacharjee/ Nov. 12, 1991
c                              latest modifications    Aug. 18, 1992
c
c       Sets the data file error flag to zero.
c       Reads the title from the input data file and print
c
      iflag=0
c      call nopen (-nt10,'nod')
c.....Input material property data
      call find ('MATP',km)
      if (km .ne. 0) then
         iflag=iflag+1
      else
         call matin (propma,ndatam,nummat,icrack)
      endif
c....Input nodal coordinates
      call find ('NODE',kn)
      if (kn .ne. 0) then
         iflag=iflag+1
      else
         call nodein (coord,numnp,fact)
      endif
c.....Input boundary conditions
      call find ('BCON',kb)
      if (kb .ne. 0) then
         iflag=iflag+1
      else
         call bouncon (ndof)
      endif
c.....Input element data
      call find ('ISOP',ke)
      if (ke .eq. 0) then
         call elein (iele,numel)
      else
         continue
      endif
      if (iflag .ne. 0) then
         write (ntm, 1001) iflag
         write (not, 1001) iflag
      else
         continue
      endif
c.....echo print of material property data
      write (not,1002)
      do 100 n=1,nummat
         write (not,1003) n,(propma(m,n),m=1,ndatam)
  100 continue
c
c      write (nt10,8001) numnp,numel
c
c.....Echo print of the nodal data
      write (not,2002)
      do 200 i=1,numnp
         write (not,2003) i,(coord(k,i),k=1,2),(ndof(k,i),k=1,3)
c         write (nt10,2003) i,(coord(k,i),k=1,2),(ndof(k,i),k=1,3)
  200 continue
c.....Echo print of element data
      write (not,4001)
      do 300 m=1,numel
         write (not,4002) m,(iele(i,m),i=1,5)
c         write (nt10,4002) m,(iele(i,m),i=1,5)
         icode(m)=0
  300 continue
c      call fclose (nt10)
c     ------------------------------------------------------------------
 1001 format (' ****** DATA READ ERROR ******',i2,/
     +' Material/nodal/element data starting with card identifier ',
     +'MATP/NODE/BCON/ISOP missing'/' Check input file and re-run')
c
 1002 format (//10x,'Material property data as read from the input file'
     +//' ID.',2X,'ELASTIC MOD.',2X,'POI. RATIO',5X,'UNIT WT.',
     + 6X,'THICKNESS',8x,'EPS-0',5X,'G-f',5X,'hc'/)
 1003 format (i3,e12.5,f12.5,e16.5,f12.5,f1.0,e15.6,f9.3,f7.3/)
c
 2002 format (///'Nodal data as read from the input data file'//
     +5x,'NODE NO.',4x,'X-COORDINATE',4X,'Y-COORDINATE',4X,'X-DOF',3x,
     +'Y-DOF',3x,'XY-DOF')
 2003 format (5x,i5,7x,f11.5,5x,f11.5,5x,i3,5x,i3,5x,i3)
c
 4001 format (///'Element data as read from the input file'//
     + ' ELEMENT ID.',5x,'CONNECTING NODES',5x,'MAT. ID.')
 4002 format (i8,5x,4i5,5x,i5)
c
 8001 format (2i15)
c
      return
      end
c     ---------------------------------------------------------------MATIN
      subroutine matin (propma,ndatam,nummat,icrack)
      implicit double precision (a-h,o-z)
      dimension propma(ndatam,1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This routine reads the material property data from the input file.
c
c
c      Input elastic material parameters.
c
      nmat=0
  100 nmat=nmat+1
      call free
      call freei ('M',imat,1)
      call freer ('E',em0,1)
      call freer ('U',enu,1)
      call freer ('W',uwt,1)
      call freer ('T',thk,1)
      if (thk .le. 0.d0) thk=1.0
      propma (1,imat)=em0
      propma (2,imat)=enu
      propma (3,imat)=uwt
      propma (4,imat)=thk
c
c     Input fracture parameters.
c
      if (icrack .ne. 0) then
         call freer ('S',sigmat,1)
         call freer ('C',cappa,1)
         call freer ('F',gf,1)
         call freer ('H',srf,1)
         propma (6,imat)=sigmat*cappa/em0
         propma (7,imat)=gf
         propma (8,imat)=srf
      else
         continue
      endif
c
c     Check for the number of properties that has been read.
c
      if (nmat .lt. nummat) go to 100
c
c     Echo print of the material properties
c
c      write (not,1001)
c      do 101 j=1,nummat
c         write (not,1002) j,(propma(i,j),i=1,ndatam)
c  101 continue
c     -----------------------------------------------------------------
c 1001 format (//10x,'Material property data as read from the input file'
c     +//' ID.',2X,'ELASTIC MOD.',2X,'POI. RATIO',2X,'UNIT WT.',
c     + 3X,'SIGMA-0',5X,'G-f',5X,'SRF'/)
c 1002 format (i3,2f12.5,2x,f10.5,f10.5,f9.5,2x,f7.3/)
c
      return
      end
c     ---------------------------------------------------------------NODEIN
      subroutine nodein (coord,numnp,fact)
      implicit double precision (a-h,o-z)
      dimension coord(2,1),dxy(2),itemp(4)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This subroutine reads the nodal coordinates from the input file.
c
c
c     read the nodal data card
c
      inode=0
  300 inode=inode+1
      call free
      call freei ('N',nodi,1)
      call freer ('X',xi,1)
      call freer ('Y',yi,1)
c      call freei ('R',itemp,2)
c
c      nodes(1,nodi)=itemp(1)
c      nodes(2,nodi)=itemp(2)
      coord(1,nodi)=xi
      coord(2,nodi)=yi
c
c     Filling the missing nodes at equal interval : F=i1,i2 (i1 and i2
c      are the two edge nodes between which filling is perfomed.
c.c     Restrain conditions are set same as those of node i1.
c
      itemp(1)=0
      call freei ('F',itemp,2)
      i1=itemp(1)
      if (i1 .le. 0) go to 302
          i2=itemp(2)
          ndiv=i2-i1
c
c          itemp(1)=nodes(1,i1)
c          itemp(2)=nodes(2,i1)
          x1=coord(1,i1)
          y1=coord(2,i1)
          x2=coord(1,i2)
          y2=coord(2,i2)
c
C          call freer ('S',dxy,2)
          div=dble(ndiv)
          dx=(x2-x1)/div
          dy=(y2-y1)/div
c          dx=dxy(1)
c          dy=dxy(2)
          inode=inode-1
          do 301 k=1,ndiv-1
             inode=inode+1
             x1=x1+dx
             y1=y1+dy
c             nodes(1,inode)=itemp(1)
c             nodes(2,inode)=itemp(2)
             coord(1,inode)=x1
             coord(2,inode)=y1
  301     continue
          inode=inode+1
  302 continue
c
c     Generate nodes from a given set: G=i1,i2,incre,itime
c                                      D=dx,dy
c
c     i1 and i2 are the edge nodes of the set from which the generation 
c      will be perfomed. All nodes between i1 and i2 will be incremnted 
c      by incre to generate a new set. This generation will be repeated  
c      itime. Coordinates of each node will be incremented by dx and dy.
c.c      Restrain conditions of the generated nodes are assumed to be free.
c
      itemp(1)=0
      call freei ('G',itemp,4)
      i1=itemp(1)
      if (i1 .le. 0) go to 305
         i2=itemp(2)
         incre=itemp(3)
         itime=itemp(4)
c
         call freer('D',dxy,2)
         dx=dxy(1)
         dy=dxy(2)
         do 304 k=1,itime
            do 303 j=i1,i2
               inode=inode+1
               nodeid=j+incre
c               nodes(1,nodeid)=0
c               nodes(2,nodeid)=0
               coord(1,nodeid)=coord(1,j)+dx
               coord(2,nodeid)=coord(2,j)+dy
  303       continue
            i1=i1+incre
            i2=nodeid
  304    continue
c
  305 continue
      if (inode .lt. numnp) go to 300
      do 400 i=1,numnp
         coord(1,i)=coord(1,i)*fact
         coord(2,i)=coord(2,i)*fact
  400 continue
c
      end
c     ---------------------------------------------------------------BOUNCON
      subroutine bouncon (ndof)
      dimension ndof(3,1),nodes(3),icond(3)
      character*1 blnk,check
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This subroutine reads the nodal boundary conditions from the input file.
c
      blnk=' '
      ncard=0
  100 continue
      call free
      call freeh (' ',check,1,1)
      if (check .eq. blnk) go to 300
      ncard=ncard+1
      call freei ('N',nodes,3)
      call freei ('R',icond,3)
      i1=nodes(1)
      i2=nodes(2)
      incr=nodes(3)
  110 continue
         ndof(1,i1)=icond(1)
         ndof(2,i1)=icond(2)
         ndof(3,i1)=icond(3)
         i1=i1+incr
         if (i1 .gt. i2) then
            go to 100
         else
            go to 110
         endif
  300 continue
      write (not,1001) ncard
      write (ntm,1001) ncard
 1001 format (' Specified boundary conditions card read',i4)
      end
c     ---------------------------------------------------------------ELEIN
      subroutine elein (iele,numel)
      implicit double precision (a-h,o-z)
      dimension iele(5,1),itemp(5)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This routine reads the element data from the input file.
c
c
c     Input element connectivity data and material ID no.
c
      nele=0
  400 nele=nele+1
      call free
      call freei ('E',id,1)
      call freei ('C',itemp,4)
      call freei ('M',mat,1)
c
      do 401 k=1,4
         iele(k,id)=itemp(k)
  401 continue
      iele(5,id)=mat
c
c     Filling the missing element IDs.
c
      itemp(1)=0
      call freei ('F',itemp,4)
      i1=itemp(1)
      if (i1 .le. 0) go to 406
        i2=itemp(2)
        incid=itemp(3)
        incnd=itemp(4) 
        nfill=(i2-i1)/incid-1
        ii=i1
        do 405 k=1,nfill
           nele=nele+1
           jj=ii
           ii=ii+incid
           do 404 j=1,4
              iele(j,ii)=iele(j,jj)+incnd
  404      continue
           iele(5,ii)=iele(5,jj)
  405   continue
  406 continue
c
c     Generate elements 
c
      itemp(1)=0
      call freei ('G',itemp,5)
      i1=itemp(1)
      if (i1 .le. 0) go to 410
        i2=itemp(2)
        incid=itemp(3)
        incnd=itemp(4) 
        ngen=itemp(5)
        ii=i1
        do 409 k=1,ngen
           do 408 m=i1,i2
               nele=nele+1
               ii=m+incid
           do 407 j=1,4
              iele(j,ii)=iele(j,m)+incnd
  407      continue
           iele(5,ii)=iele(5,m)
  408      continue
        i1=i1+incid
        i2=ii
  409   continue
  410 continue
c
      if (nele .lt. numel) go to 400
c
c
c     Echo print of element data
c
c      write (not,4001)
c      do 411 m=1,numel
c         write (not,4002) m,(iele(i,m),i=1,5)
c  411 continue
c
c
c     ----------------------------------------------------------------
c 4001 format (///10x,' Element data as read from the input file'//
c     + ' ELEMENT ID.',5x,'CONNECTING NODES',5x,'MAT. ID.'/)
c 4002 format (i8,8x,4i4,6x,i5)
c
      return
      end
